---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：24-Dynamic Routes

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **C-12**：App Routerでのparamsがpromiseとして提供される具体的実装の根拠確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/shared/lib/router/utils/is-dynamic.ts` - 動的ルート判定
- E-02: `packages/next/src/shared/lib/router/utils/is-dynamic.test.ts` - テスト
- E-03: `packages/next/src/shared/lib/router/utils/route-regex.ts` - 正規表現生成
- E-04: `packages/next/src/shared/lib/router/utils/get-dynamic-param.ts` - パラメータパース
- E-05: `packages/next/src/shared/lib/router/utils/get-segment-param.tsx` - セグメントパラメータ
- E-06: `packages/next/src/server/render.tsx` - render内でのisDynamicRoute使用
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isDynamicRouteで[param]パターンを正規表現でチェック | E-01 (7-10行目, 19-29行目) | ○ |
| C-02 | TEST_STRICT_ROUTEでセグメント全体が[param]形式かチェック | E-01 (10行目) | ○ |
| C-03 | TEST_ROUTEでプレフィックス/サフィックスを許容 | E-01 (7行目) | ○ |
| C-04 | インターセプトルートの場合はinterceptedRouteに対して判定 | E-01 (20-22行目) | ○ |
| C-05 | [param]は1セグメントにマッチ | E-03 | ○ |
| C-06 | [...slug]は1つ以上のセグメントにマッチ | E-03 | ○ |
| C-07 | [[...slug]]は0個以上にオプショナルマッチ | E-03 | ○ |
| C-08 | getRouteRegexで正規表現とグループ情報を生成 | E-03 (16-19行目) | ○ |
| C-09 | 動的SSGページにgetStaticPathsが必須 | E-06 (596-601行目) | ○ |
| C-10 | 静的ルート > 動的ルート > キャッチオールの優先順位 | E-03 | ○ |
| C-11 | PARAMETER_PATTERNによる動的パラメータのパース | E-04 | ○ |
| C-12 | App Routerではparamsがpromiseとして提供 | **根拠なし** (概念的知識) | △ |

## 4) 不足情報（Unknown / Missing）
- App Routerでのparams Promiseラッピングの具体的実装箇所が未確認
  - 候補：`packages/next/src/server/request/params.ts` / `packages/next/src/server/app-render/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - isDynamicRouteの判定ロジックは明確に確認済み
- 0: 低リスク - RouteRegexの型定義とグループ情報は確認済み
- 0: 低リスク - render.tsxでの排他チェックも確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] isDynamicRouteのstrictモードの違いが正しく説明されているか確認
- [ ] 正規表現生成ロジックの[param]/[...slug]/[[...slug]]の違いを確認
- [ ] App RouterでのParams Promiseの具体的実装を確認
